0 LEN_INT !   \\\\ This is a FORTH part of FORTH source \\\\
CLS
 HERE @ BYE-M ! HERE @
22 WORD  FORTH terminated" HERE @ OVER + HERE ! -ROT SWAP ROT CMOVE 0 C,

 : >MARK HERE @ 0 , ;   : >RESOLVE HERE @ SWAP ! ;
 : <MARK HERE @ ;       : <RESOLVE , ;
 : TUCK SWAP OVER ;
 : 0! 0 SWAP ! ;

 : IMMEDIATE CURRENT @ @ DUP C@ 80 OR SWAP C! ;

 : IF COMPILE ?BRANCH >MARK ; IMMEDIATE
 : CELLS 2* ;
 : CHARS ; IMMEDIATE : ALIGN ; IMMEDIATE

 : ELSE COMPILE BRANCH >MARK SWAP >RESOLVE ; IMMEDIATE
 : THEN >RESOLVE ; IMMEDIATE
 : BEGIN <MARK ; IMMEDIATE
 : UNTIL COMPILE ?BRANCH <RESOLVE ; IMMEDIATE
 : AGAIN COMPILE BRANCH <RESOLVE ; IMMEDIATE
 : WHILE COMPILE ?BRANCH >MARK ; IMMEDIATE
 : REPEAT COMPILE BRANCH SWAP <RESOLVE >RESOLVE ; IMMEDIATE

 : ERR W_EXIT @ EXECUTE ;

 : [COMPILE] BL WORD FIND IF NAME> , ELSE ERR THEN ; IMMEDIATE
 : C" BL WORD DROP C@ [COMPILE] LITERAL ; IMMEDIATE
 : ( 29 WORD 2DROP ; IMMEDIATE  : .( 29 WORD TYPE CR ; IMMEDIATE
 : \ 0 WORD 2DROP ; IMMEDIATE ( comments defined )

 .( Sprinter-FORTH... wait please) CR
 ( NOW comments may be used )

 : SP> SYS-ID NOT IF LEN_INT 0! THEN ; IMMEDIATE \ for Sprinter only commands
 : PC> SYS-ID IF LEN_INT 0! THEN ; IMMEDIATE     \ for PC only commands

 : (DO) R> DUP @ >R ROT >R SWAP >R 2+ >R ;
 : (?DO) 2DUP - 0= IF 2DROP R> @ >R ELSE R> DUP @ >R ROT >R SWAP >R 2+ >R THEN ;
 : (LOOP) R> R> 1+ R> 2DUP - 0= IF 2DROP 2+ R> DROP ELSE >R >R @ THEN >R ;
 : (+LOOP) R> SWAP R> + R> 2DUP - 0= IF 2DROP 2+ R> DROP ELSE >R >R @ THEN >R ;
 : LEAVE R> R> R> 2DROP DROP ;

 : ?DO COMPILE (?DO) >MARK <MARK ; IMMEDIATE
 : DO COMPILE (DO) >MARK <MARK ; IMMEDIATE
 : LOOP  COMPILE (LOOP)  <RESOLVE >RESOLVE ; IMMEDIATE
 : I R> R> DUP >R SWAP >R ;
 : +LOOP COMPILE (+LOOP) <RESOLVE >RESOLVE ; IMMEDIATE

 : ' BL WORD FIND ?EXIT ERR ;
 : ['] ' [COMPILE] LITERAL ; IMMEDIATE

 ( execution for CONSTANSs from 0 and 0. )
 : CONSTANT CREATE , [ BL WORD 0 FIND DROP NAME> @ ] LITERAL HERE @ 4 - ! ;
 : 2CONSTANT CREATE , , [ BL WORD 0. FIND DROP NAME> @ ] LITERAL HERE @ 6 - ! ;

 : VARIABLE CREATE 0 , ;
 : 2VARIABLE CREATE 0. , , ;

 : -> BL WORD FIND IF NAME> >BODY
	STATE @ IF [COMPILE] LITERAL COMPILE ! ELSE ! THEN
	ELSE W_EXIT @ EXECUTE THEN ; IMMEDIATE

 CREATE S0 BE00 ,  CREATE R0 BF00 ,  CREATE CSP 0 ,

 : !CSP SP@ CSP ! ; : DEPTH SP@ S0 @ SWAP - ;

 : RDROP R> DROP ;  : ERASE 0 FILL ;  : BLANK BL FILL ;
 : QUIT RDROP EXIT ;

 : COUNT C@+ ;

 : > - 0> ; : <= - 0> NOT ; : D> D- D0> ;  : = - 0= ; : D= D- D0= ;
 : < - 0< ; : >= - 0< NOT ; : D< D- D0< ;  : <> - 0<> ; : D<> D- D0<> ;

 : PICK 1+ 2* SP@ + @ ;

 : DP! HERE ! ;  : ALLOT HERE @ + HERE ! ;  : ". C@+ TYPE ;

 : S, HERE @ 2DUP C! 1+ SWAP 2DUP + HERE @ >R HERE ! CMOVE R> ;

 : ," C" " WORD S, DROP ;  : " COMPILE LIT' ," ; IMMEDIATE

 : ." [COMPILE] " COMPILE TYPE ; IMMEDIATE
 : SPACE BL EMIT ;

\ : SPACES BEGIN DUP 0 > WHILE BL EMIT 1- REPEAT DROP ;
 : SPACES DUP 0 > IF BL EMITS ELSE DROP THEN ;
 : ID. ". SPACE ;  : HEX 10 BASE ! ;  : DECIMAL 0A BASE ! ;

 : HOLD HLD @ 1- DUP HLD ! C! ;

 : <# PAD HLD ! ;  : #> HLD @ PAD OVER - ;

 : HX. DUP 0F AND ALPHA HOLD 2/ 2/ 2/ 2/ ;
 : H. <# HX. HX. HX. HX. DROP #> TYPE SPACE ;
 : DH. <# HX. HX. HX. HX. DROP HX. HX. HX. HX. DROP #> TYPE SPACE ;

 : # BASE @ M/MOD ALPHA HOLD ;  : #S BEGIN # 2DUP OR 0 = UNTIL 2DROP ;
 : SIGN 0 < IF 2D HOLD THEN ;
 : D.N->L >R OVER >R DABS <# #S R> SIGN #> R> OVER - ;
 : D.N D.N->L SPACES TYPE ;
 : D. 0 D.N SPACE ;  : . S>D D. ;  : U. 0 D. ;   : ? @ . ;
 : .R >R S>D R> D.N ; : U.N >R 0 R> D.N ;

 VARIABLE LINE  VARIABLE L-KEY   VARIABLE EDGE   VARIABLE ERROR
 VARIABLE POSN  VARIABLE SPAN

\ system dependent word
SP> CREATE S-SIZE 2050 ,        \ Sprinter screen 32x80
PC> CREATE S-SIZE 1950 ,        \ PC screen 25x80

\ color definitions "WHITE"
 : C-M 70 COLOR ! ; : C-H 1B COLOR ! ; : C-E CA COLOR ! ;
 : C-C 1C COLOR ! ; : C-X 1A COLOR ! ; : C-O 76 COLOR ! ;

\ color definitions "NORTON"
( : C-M 1B COLOR ! ; : C-H 30 COLOR ! ; : C-E CA COLOR ! ; )
( : C-C 3C COLOR ! ; : C-X 3A COLOR ! ; : C-O 1F COLOR ! ; )

\ words for interpreter FORTH-SYSTEM

 : LAST-L S-SIZE @ FF00 AND 100 - ;

 : CLL GET_POS FF00 AND SET_POS S-SIZE @ FF AND 1- SPACES BL EMITX GET_POS FF00 AND SET_POS ;

 : AT GET_POS - 00FF AND SPACES ;

\ Headers

 : L-HEAD C-H LAST-L SET_POS ." (C) 2002 Ivan Mak"
   LAST-L 40 + AT ." BASE: " BASE @ DUP DECIMAL . BASE ! ." (dec)"
   4F AT BL EMITX 0 SET_POS ;

 : H-HEAD C-H 0 SET_POS ." Sprinter-FORTH ver 0.07"
   001E AT ERROR @ IF C-E ."  ERROR " C-H THEN
   0028 AT C-H ." HERE:" HERE @ H. ."   SP:" SP@ 8 + H. ."   RP:" RP@ 0A + H.
   0048 AT STATE @ IF C-C ." Compile " ELSE C-X ." Execute " THEN ;

VARIABLE H-FLAG H-FLAG 0!
VARIABLE ESC-W
BL WORD BYE FIND DROP NAME> ESC-W !

 : BYE-X ESC-W @ EXECUTE ;

 : HEADER H-FLAG @ ?EXIT COLOR @ GET_POS L-HEAD H-HEAD SET_POS COLOR ! ;

 : W-CURS HEADER GET_POS DUP POSN @ + SET_POS WAIT-KEY SWAP SET_POS ;

\ parts of line editor

 : EDGE-TEST POSN @ EDGE @ =  IF -1 POSN +! THEN POSN @ -1 = IF POSN 0! THEN ;
 : L-EDGE POSN @ 0= ;  : R-EDGE POSN @ 1+ EDGE @ = ;

 : -POS -1 POSN +! EDGE-TEST ; : +POS 1 POSN +! EDGE-TEST ;
 : L+POS LINE @ POSN @ + ;

 : INS-X ( byte --> )
   EDGE @ POSN @ - DUP 0> NOT IF DROP EXIT THEN
   >R L+POS DUP DUP 1+ R> CMOVE> C! +POS ;

 : DELX ( --> ) L-EDGE ?EXIT -POS
   EDGE @ POSN @ - DUP 0> NOT IF DROP EXIT THEN
   >R LINE @ EDGE @ + BL SWAP C!
   L+POS DUP 1+ SWAP R> CMOVE ;

 : PRE-BL -POS L+POS C@ BL = +POS ;
 : POS-BL L+POS C@ BL = ;

 : BL-DEL BEGIN DELX L-EDGE ?EXIT PRE-BL NOT ?EXIT AGAIN ;
 : WR-DEL BEGIN DELX L-EDGE ?EXIT PRE-BL ?EXIT AGAIN ;

 : DELW L-EDGE ?EXIT PRE-BL IF BL-DEL ELSE WR-DEL THEN ;

 : BL-LEFT  BEGIN -POS L-EDGE ?EXIT PRE-BL NOT ?EXIT AGAIN ;
 : WR-LEFT  BEGIN -POS L-EDGE ?EXIT PRE-BL ?EXIT AGAIN ;
 : BL-RIGHT BEGIN +POS R-EDGE ?EXIT POS-BL NOT ?EXIT AGAIN ;
 : WR-RIGHT BEGIN +POS R-EDGE ?EXIT POS-BL ?EXIT AGAIN ;

 : W-LEFT  L-EDGE ?EXIT PRE-BL IF BL-LEFT WR-LEFT ELSE WR-LEFT  THEN ;
 : W-RIGHT R-EDGE ?EXIT POS-BL IF BL-RIGHT ELSE WR-RIGHT BL-RIGHT THEN
   R-EDGE IF BL-LEFT THEN ;

 : L-END LINE @ EDGE @ -TRAILING POSN ! DROP ;

 : INSERT FF AND DUP 01F > IF INS-X ELSE DROP THEN ;
 : TEST-0D L-KEY @ 0D = ;
 : TYPE-X 2DUP GET_POS >R TYPE R> SET_POS ;
 : TAB+  POSN @ FFF8 AND 8 + POSN ! EDGE-TEST ;
 : TAB- -POS POSN @ FFF8 AND POSN ! ;
 : HOME-POS POSN 0! ;
 : END-POS L-END EDGE-TEST ;

\ key press

\ system dependent word
 : DIR-KEY DUP FF AND L-KEY !
\      Sprinter key code       PC key code
\            ||||                ||||
DUP [ SYS-ID 011B AND SYS-ID NOT 011B AND OR ] LITERAL = IF DROP BYE-X EXIT THEN               ( ESC )
DUP [ SYS-ID 4400 AND SYS-ID NOT 4400 AND OR ] LITERAL = IF DROP BYE-X EXIT THEN               ( F10 )
DUP [ SYS-ID 5400 AND SYS-ID NOT 4B00 AND OR ] LITERAL = IF DROP -POS EXIT THEN    ( <- )
DUP [ SYS-ID 5600 AND SYS-ID NOT 4D00 AND OR ] LITERAL = IF DROP +POS EXIT THEN    ( -> )
DUP [ SYS-ID 0F09 AND SYS-ID NOT 0F09 AND OR ] LITERAL = IF DROP TAB+ EXIT THEN    ( tab )
DUP [ SYS-ID 8F09 AND SYS-ID NOT 0F00 AND OR ] LITERAL = IF DROP TAB- EXIT THEN    ( <tab )
DUP [ SYS-ID 0E08 AND SYS-ID NOT 0E08 AND OR ] LITERAL = IF DROP DELX EXIT THEN    ( <del )
DUP [ SYS-ID 8E00 AND SYS-ID NOT 0E7F AND OR ] LITERAL = IF DROP DELW EXIT THEN    ( ctrl<del )
DUP [ SYS-ID D400 AND SYS-ID NOT 7300 AND OR ] LITERAL = IF DROP W-LEFT EXIT THEN  ( <ctrl )
DUP [ SYS-ID D600 AND SYS-ID NOT 7400 AND OR ] LITERAL = IF DROP W-RIGHT EXIT THEN ( ctrl> )
DUP [ SYS-ID 5700 AND SYS-ID NOT 4700 AND OR ] LITERAL = IF DROP HOME-POS EXIT THEN ( home )
DUP [ SYS-ID D700 AND SYS-ID NOT 7700 AND OR ] LITERAL = IF DROP HOME-POS EXIT THEN ( ctrl.home )
DUP [ SYS-ID 5100 AND SYS-ID NOT 4F00 AND OR ] LITERAL = IF DROP END-POS EXIT THEN  ( end )
DUP [ SYS-ID D100 AND SYS-ID NOT 7500 AND OR ] LITERAL = IF DROP END-POS EXIT THEN  ( ctrl.end )
 INSERT ;   \ all other keys

\ main cycle of line editor

 : EXPECT-LOOP BEGIN TYPE-X W-CURS 0 ERROR ! DIR-KEY TEST-0D UNTIL ;

 : (EXPECT) POSN 0! 2DUP EDGE ! LINE ! EXPECT-LOOP 2DROP L-END POSN @ SPAN ! ;
 : EXPECT 2DUP BLANK (EXPECT) ;
 : CRS CR GET_POS S-SIZE @ FF00 AND 100 - = IF 0100 SET_POS THEN CLL ;

 : QUERY CRS TIB 50 EXPECT >IN 0! BLK 0! SPAN @ #TIB ! CRS ;

 : INC-END HANDLE @ ?DUP IF CLOSE-FILE DROP THEN HANDLE 0! ;

 : FORTH-SYSTEM S0 @ SP! R0 @ RP! INC-END BEGIN QUERY TIB #TIB @ (INTERPRET)
   STATE @ ERROR @ OR IF ELSE COLOR @ C-O ." Ok" COLOR ! THEN AGAIN ;

 : (ABORT) 1 ERROR ! FORTH-SYSTEM ;

VARIABLE (A)
BL WORD (ABORT) FIND DROP NAME> (A) ! ;

 : ABORT (A) @ EXECUTE ;
 : ABORT" [COMPILE] " COMPILE TYPE COMPILE ABORT ; IMMEDIATE
 : ABORTX ABORT"  ?" ;

 HERE @ I/O-M ! HERE @
22 WORD File I/O error" HERE @ OVER + HERE ! -ROT SWAP ROT CMOVE 0 C,

 : ?I/O ?EXIT I/O-M @ ?DUP IF TYPE-Z THEN ABORT ;

 : C-FILE BL WORD CREATE-FILE ?I/O ;
 : O-FILE BL WORD OPEN-FILE ?I/O ;
 : SAVE C-FILE DUP >R WRITE-FILE ?I/O R> CLOSE-FILE ?I/O ;
 : READ O-FILE DUP >R  READ-FILE ?I/O R> CLOSE-FILE ?I/O ;

\ system-dependent command

\ PC only
PC> : SAVE-SYSTEM 100 HERE @ 100 - SAVE . ." bytes saved" ;

\ Sprinter only
\ header for sprinter EXE file
SP> CREATE (HEAD) C" E C, C" X C, 45 , 200 , 0 , 0 , 0 , 0 , 0 , 4100 , 4100 , BFFE ,
SP> : SAVE-SYSTEM C000 200 2DUP ERASE (HEAD) C000 16 CMOVE
SP>   C-FILE DUP >R WRITE-FILE ?I/O
SP>   4100 HERE @ 4100 - R@ WRITE-FILE ?I/O R>
SP>   CLOSE-FILE ?I/O + . ." bytes saved" ;

BL WORD ABORTX FIND DROP NAME> W_EXIT !

 : MAKE BL WORD FIND DROP NAME> W-START ! BYE-M 0! ;
BYE-M @ MAKE FORTH-SYSTEM BYE-M !

FILE-M 0!

 : INCLUDE INC-END BL WORD (INCLUDE) INC-END FORTH-SYSTEM ;

 : MAX 2DUP > IF DROP ELSE NIP THEN ;
 : MIN 2DUP > IF NIP ELSE DROP THEN ;

\ INCLUDE _menu.frt

C-M CLS FORTH-SYSTEM

BYE

