;[BEGIN]===================================================
;
; IF.EXE
;
; IF [num] [prog1.exe] ? [prog2.exe] : [prog3.exe]
;
	ORG	#8100-512
	INCLUDE	"dss.inc"
;==EXE HEADER =============================================
	DB	"EX"	;EXE ID
	DB	#45	;EXE TYPE
	DB	#00	;EXE VERSION
	DW	#0200	;CODE OFFSET LOW WORD
	DW	#0000	;CODE OFFSET HIGH WORD
	DW	#0000	;PRIMARY LOADER
	DW	#0000	;RESERVED
	DW	#0000	;RESERVED
	DW	#0000	;RESERVED
	DW	START	;LOAD ADDRESS
	DW	START	;START ADDRESS
	DW	#BFFF	;STACK ADDRESS
	DS	490	;RESERVED
;==========================================================
;IF.EXE EXITCODES
EC_TRUE		EQU	0
EC_FALSE	EQU	1
EC_NORMAL	EQU	2
EC_LAUNCH_ERROR	EQU	3
EC_NO_MAINPROG	EQU	4
EC_OLD_DSS	EQU	5

;MAIN ENTRY
START	PUSH	IX
	LD	A,MSG_HELLO
	CALL	MESSAGE		;Hello message
	CALL	INIT		;Initialize variables
	LD	C,DSS_VERSION
	RST	#10		;GET DSS VERSION
	EX	DE,HL
	AND	A
	LD	DE,#0136	;1.54
	SBC	HL,DE		;CHECK DSS VERSION
	POP	HL
	JR	C,OLD_DSS
	CALL	EX_COMMAND_LINE	;Parse command line

	LD	B,EC_NORMAL
	LD	A,(STOPMODE)
	OR	A
	JR	NZ,QUIT		;Quit IF.EXE (specified stopmode)

	LD	A,(CMDFLAG)
	BIT	BITMAIN,A
	JR	Z,NOMAINP	;No main program
	LD	HL,MAIN_PROG
	CALL	LAUNCH		;Launch main program
	LD	B,EC_LAUNCH_ERROR
	JR	C,QUIT		;Launch failed, quit
	LD	(EXIT_CODE),A	;Save exitcode of main program
	LD	HL,PRM1
	CALL	PRINTNUM	;Prepare %1 value
	LD	A,MSG_EXITCODE
	CALL	MESSAGE		;Show message
	LD	HL,ERR_CODE
	LD	A,(EXIT_CODE)
	CP	(HL)		;Main condition
	JR	NZ,FALSE_
TRUE_
	LD	B,EC_TRUE
	LD	A,(CMDFLAG)
	BIT	BITTRUE,A
	JR	Z,NEXT_		;Command line haven't a program for TRUE condition
	LD	HL,TRUE_PROG
	CALL	LAUNCH		;Launch it
	LD	B,EC_TRUE
	JR	NEXT_		;Quit with TRUE exitcode
FALSE_
	LD	B,EC_FALSE
	LD	A,(CMDFLAG)
	BIT	BITFALSE,A
	JR	Z,NEXT_		;Command line haven't a program for FALSE condition
	LD	HL,FALSE_PROG
	CALL	LAUNCH		;Launch it
	LD	B,EC_FALSE
				;Quit with FALSE exitcode
NEXT_

QUIT	PUSH	BC
	CALL	CRLF
	POP	BC
	LD	C,DSS_EXIT
	RST	#10
	RET

NOMAINP
	LD	A,MSG_USAGE
	CALL	MESSAGE
	LD	B,EC_NO_MAINPROG
	JR	QUIT

OLD_DSS
	LD	A,MSG_OLD_DSS
	CALL	MESSAGE
	LD	B,EC_OLD_DSS
	JR	QUIT

;Program launcher
LAUNCH	PUSH	HL
	PUSH	HL
	LD	C,DSS_CURDISK	;
	RST	#10		;
	LD	HL,BUFFER	;
	ADD	A,"A"		;
	LD	(HL),A		;
	INC	HL		; Prepare prompt like "c:\>".
	LD	A,":"		;
	LD	(HL),A		;
	INC	HL		;
	LD	C,DSS_CURDIR	;
	RST	#10		;
	LD	HL,BUFFER
	LD	C,DSS_PCHARS
	RST	#10		; Show it
	LD	A,">"		;
	LD	C,DSS_PUTCHAR	;
	RST	#10		;
	POP	HL
	LD	C,DSS_PCHARS
	RST	#10
	CALL	CRLF
	POP	HL
	LD	C,DSS_EXEC
	RST	#10		;Launch the program
	RET	NC		;Launch OK
	CALL	ERROR		;Show DSS error
	SCF
	RET

;Initialize variables
INIT
	XOR	A
	LD	(STOPMODE),A
	LD	(NAME_FLG),A
	LD	(ERR_CODE),A
	LD	(EXIT_CODE),A
	LD	(MAIN_PROG),A
	LD	(TRUE_PROG),A
	LD	(FALSE_PROG),A
	RET

;VARIABLES

STOPMODE
	DB	0
NAME_FLG
	DB	0
ERR_CODE
	DB	0
EXIT_CODE
	DB	0

CMDFLAG	DB	#00
;D0 - THE EXITCODE VALUE ARE SPECIFIED
;D1 - THE PROGRAM FOR TRUE EXITCODE CONDITION ARE SPECIFIED
;D2 - THE PROGRAM FOR FALSE EXITCODE CONDITION ARE SPECIFIED
;D3 - THE MAIN LAUNCHED PROGRAM ARE SPECIFIED

BITCODE	EQU	0
BITTRUE	EQU	1
BITFALSE EQU	2
BITMAIN	EQU	3

; Parse command line
; HL - exe-prefix

EX_COMMAND_LINE
	INC	HL
	LD	DE,MAIN_PROG
	LD	(C_DATA_POS),DE
NEXTPR	LD	DE,ARGCBUF
	LD	BC,#0745
	RST	#10
	PUSH	AF
	PUSH	HL
	LD	DE,(ARGCBUF)
	LD	HL,#003F	;"?"
	AND	A
	SBC	HL,DE
	JR	Z,TRUE_SW
	LD	HL,#003A	;":"
	AND	A
	SBC	HL,DE
	JR	Z,FALSE_SW
	LD	A,(CMDFLAG)
	AND	#09
	JR	NZ,STEP2
	CALL	IS_NUMERIC
	JR	NC,EOCL
	LD	A,(ARGCBUF)
	OR	A
	JR	Z,EOCL		;end of command line
	CP	"-"
	JR	Z,ITCKEY
	CP	"/"
	JR	Z,ITCKEY
STEP2
	LD	DE,(C_DATA_POS)
	LD	HL,ARGCBUF
	LD	A,(CMDFLAG)
	SET	BITMAIN,A
	LD	(CMDFLAG),A
MOVDATA	LD	A,(HL)
	LDI
	OR	A
	JR	NZ,MOVDATA
	DEC	DE
	LD	A," "
	LD	(DE),A
	INC	DE
	LD	(C_DATA_POS),DE
EOCL	POP	HL
	POP	AF
	JR	NC,NEXTPR
	LD	HL,(C_DATA_POS)
	DEC	HL
	LD	(HL),0
	RET

TRUE_SW
	LD	A,(CMDFLAG)
	SET	BITTRUE,A
	LD	(CMDFLAG),A
	LD	HL,(C_DATA_POS)
	DEC	HL
	LD	(HL),0
	LD	HL,TRUE_PROG
	LD	(C_DATA_POS),HL
	JR	EOCL

FALSE_SW
	LD	A,(CMDFLAG)
	SET	BITFALSE,A
	LD	(CMDFLAG),A
	LD	HL,(C_DATA_POS)
	DEC	HL
	LD	(HL),0
	LD	HL,FALSE_PROG
	LD	(C_DATA_POS),HL
	JR	EOCL

C_DATA_POS	DW	0

ITCKEY	LD	A,(ARGCBUF+1)
	CP	"a"
	JR	C,KNU
	RES	5,A
KNU
	CP	"H"
	JR	Z,HELP
	CP	"?"
	JR	Z,HELP
	LD	HL,ARGCBUF
	CALL	PUTVAR
	LD	A,MSG_UNK_PARAMETER
	CALL	MESSAGE
	LD	A,1
	LD	(STOPMODE),A
	JR	EOCL

HELP	LD	A,MSG_USAGE
	CALL	MESSAGE
	LD	A,1
	LD	(STOPMODE),A
	JR	EOCL

IS_NUMERIC
	LD	HL,ARGCBUF
	LD	A,(HL)
	OR	A
	SCF
	RET	Z	;NO DIGIT
	LD	C,0
IS_N1	CALL	STR2NUM
	RET	C
	INC	HL
	LD	A,(HL)
	OR	A
	JR	NZ,IS_N1
	LD	A,C
	LD	(ERR_CODE),A
	LD	A,(CMDFLAG)
	SET	BITCODE,A
	LD	(CMDFLAG),A
	AND	A
	RET


; C - VALUE "0..255"
; A - DIGIT "0".."9"

STR2NUM	CP	"0"
	RET	C
	CP	"9"+1
	CCF
	RET	C
	SUB	"0"
	LD	B,A	;SAVE DIGIT
	LD	A,C
	ADD	A,A
	ADD	A,A
	ADD	A,C
	ADD	A,A	;VALUE x 10
	ADD	A,B	;VALUE + DIGIT
	LD	C,A
	AND	A
	RET

ARGCBUF	DS	256

CR	EQU	13
LF	EQU	10

; Send CR and LF to the console
CRLF	LD	A,CR
	LD      C,DSS_PUTCHAR
	RST     #10
	LD      A,LF
	LD      C,DSS_PUTCHAR
	RST     #10
	RET

; DSS error messages
ERROR	LD	E,A
	LD	D,0
	JP	ERR_MSG

ERR_MSG	CALL	FMESAGE
	CALL	PRINTZ
	CALL	CRLF
	RET

FMESAGE	INC	DE
	LD	HL,ERR0
	LD	BC,ERR1-ERR0
LCPIR	XOR	A
	CPIR
	RET	PO
	RET	NZ
	DEC	DE
	LD	A,D
	OR	E
	JP	NZ,LCPIR
	RET

ERR0	DB	#00
	DB	"No errors",0
	DB	"Invalid function",0
	DB	"Invalid drive number",0
	DB	"File not found",0
	DB	"Path not found",0
	DB	"Invalid handle",0
	DB	"Extended error 6",0
	DB	"File exist",0
	DB	"File read only",0
	DB	"Root overflow",0
	DB	"No free space",0
	DB	"Directory not empty",0
	DB	"Can't delete current directory",0
	DB	"Invalid media",0
	DB	"Unknow operation",0
	DB	"Directory exist",0
	DB	"Invalid filename",0
	DB	"Invalid EXE-file",0
	DB	"Not supported EXE-file",0
	DB	"Access denied",0
	DB	"Not ready",0
	DB	"Seek error",0
	DB	"Sector not found",0
	DB	"CRC error",0
	DB	"Write protect",0
	DB	"Read error",0
	DB	"Write error",0
	DB	"Drive failure",0
	DB	"Extended error 28",0
	DB	"Extended error 29",0
	DB	"No free memory",0
	DB	"Invalid memory handle",0
	DB	"Extended error 32",0
	DB	"Extended error 33",0
	DB	"Extended error 34",0
	DB	"35",0
	DB	"36",0
	DB	"37",0
	DB	"38",0
	DB	"39",0
	DB	"40",0
	DB	"41",0
	DB	"42",0
	DB	"43",0
	DB	"44",0
	DB	"45",0
	DB	"46",0
	DB	"47",0
	DB	"48",0
	DB	"49",0
	DB	"50"
	DB	0
ERR1

; Find message
FIND_MESSAGE
	LD	E,A
	LD	D,0
	CALL	MESAGE
	RET

; Console messages
MESSAGE	LD	E,A
	LD	D,0
	CALL	MESAGE
	CALL	PRINTZ
	RET

MESAGE	INC	DE
	LD	HL,MSG0
	LD	BC,MSG1-MSG0
LCPIR2	XOR	A
	CPIR
	RET	PO
	RET	NZ
	DEC	DE
	LD	A,D
	OR	E
	JP	NZ,LCPIR2
	RET

PRINTZ	LD	A,(HL)
	INC	HL
	OR	A
	RET	Z
	CP	"%"
	JR	NZ,PRINTZ2
	LD	A,(HL)
	INC	HL
	SUB	"1"
	PUSH	HL
	LD	L,A
	LD	H,0
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	LD	BC,PRM1
	ADD	HL,BC
	LD	C,DSS_PCHARS
	RST	#10
	POP	HL
	JR	PRINTZ
PRINTZ2	LD	C,DSS_PUTCHAR
	RST	#10
	JP	PRINTZ

PUTVAR	LD	DE,PRM1
PUTPRM	LD	BC,15
PUTPRMA	LD	A,(HL)
	LDI
	RET	PO
	OR	A
	JR	NZ,PUTPRMA
	RET

PRM1    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
PRM2    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
PRM3    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
PRM4    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
PRM5    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
PRM6    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
PRM7    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
PRM8    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
PRM9    DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

MSG_HELLO	EQU	0
MSG_USAGE	EQU	1
MSG_UNK_PARAMETER	EQU	2
MSG_EXITCODE	EQU	3
MSG_OLD_DSS	EQU	4

MSG0	DB	0
;0
	DB	"IF utility v1.00, 2002 (c) PETERS PLUS LTD",CR,LF,CR,LF,0
;1
	DB	"  Usage: IF.EXE [-switches] [exitcode] [file.exe] [? true.exe] [: false.exe]",CR,LF,CR,LF
	DB	"  Switches:",CR,LF
	DB	"    -h, -?    Help page",CR,LF,CR,LF
	DB	"  Return codes:",CR,LF
	DB	"    0         TRUE condition",CR,LF
	DB	"    1         FALSE condition",CR,LF
	DB	"    2         No errors",CR,LF
	DB	"    3         Can't launch main program",CR,LF
	DB	"    4         Missed filename of main program",CR,LF
	DB	0
;2
	DB	"  Error: Unknown switch: %1",CR,LF,0
;3
	DB	"Terminated with exitcode: %1",CR,LF,0
;4
	DB	"  Error: Need DSS version 1.54 or higher",CR,LF,0
;5
	DB	0
MSG1

; Put decimal value into the memory as string
PRINTNUM
	LD	DE,#FFFF
	LD	B,100
NUM100	INC	D
	SUB	B
	JR	NC,NUM100
	ADD	A,B
	LD	B,10
NUM10	INC	E
	SUB	B
	JR	NC,NUM10
	ADD	A,B
	LD	C,A
	LD	A,D
	OR	A
	JR	NZ,PN3
	OR	E
	JR	NZ,PN2
PN1	LD	A,"0"
	ADD	A,C
	LD	(HL),A
	INC	HL
	LD	(HL),0
	RET
PN3	LD	A,"0"
	ADD	A,D
	LD	(HL),A
	INC	HL
PN2	LD	A,"0"
	ADD	A,E
	LD	(HL),A
	INC	HL
	JR	PN1

;Work buffers
MAIN_PROG	EQU	$
TRUE_PROG	EQU	$+256
FALSE_PROG	EQU	$+512
BUFFER		EQU	$+768
	DB	0
;                                            Denis Parinov
;[END]=====================================================
