;Skeleton for Assembly programs in MASM-80.

	ASEG
	ORG	100h
	.PHASE	8100h - 512
	INCLUDE C:\UTIL\MASM80\ASM\COMMON\DOS_EQU.ASM
	INCLUDE	C:\UTIL\MASM80\ASM\COMMON\BIOS_EQU.ASM

;EXE file header
	DW	5845h		;EXE signature
	DB	45h		;Reserved (EXE.Type)
	DB	00h		;EXE.Version
	DW	0200h		;Code offset
	DW	0000h
	DW	0000h		;Primary loader or 0 (no primary loader)
	DW	0000h		;Reserved
	DW	0000h		;Reserved
	DW	0000h		;Reserved
	DW	OrgAddr		;Code Load Address
	DW	Start		;Run address (PC.Register)
	DW	0BFFFh		;Stack address (SP.Register)
	DS	490		;Dummy, reserved

OrgAddr:

	INCLUDE	C:\UTIL\MASM80\ASM\COMMON\UTILS.ASM

AddendName:	DEFB	"Addend",00
AugendName:	DEFB	"Augend",00

AddendAsc:	DEFS	128,00
AugendAsc:	DEFS	128,00

Addend:		DEFB	00,00
Augend:		DEFB	00,00

SumAsc:		DEFS	128,00
Sum:		DEFB	00,00

AddMssg:	DEFB	"%1 + %2 = %3 dec.",0Dh,0Ah,00
AddScrn:	DEFS	128,00

MacroStart:	DEFB	00
MacroText:	DEFS	128,00

ErrorMssg:	DEFB	"There was an error somewhere!",0Dh,0Ah,00

Start:
GetAddend:
		LD	HL,AddendAsc
		PUSH	HL
		LD	HL,AddendName
		PUSH	HL
		PUSH	IX
		CALL	GetSwitch	;Get first param ASCII form 
		JR	C,Error
		LD	HL,AddendAsc
		PUSH 	HL
		CALL	Ascii2Word	;Get first param binary value
		LD	(Addend),HL
		JR	C,Error
GetAugend:
		LD	HL,AugendAsc
		PUSH	HL
		LD	HL,AugendName
		PUSH 	HL
		PUSH	IX
		CALL	GetSwitch	;Get second param ASCII form
		JR	C,Error
		LD	HL,AugendAsc
		PUSH	HL
		CALL	Ascii2Word	;Get second param binary value
		LD	(Augend),HL
		JR	C,Error
DoAddition:
		LD	DE,(Addend)
		LD	HL,(Augend)
		AND	A		;Clear carry
		ADC	HL,DE
		JR	C,Error
		LD	(Sum),HL
		PUSH	HL
		LD	HL,SumAsc
		PUSH	HL
		CALL	Word2Ascii	;Convert sum to ascii

CompAddend:
		LD	HL,MacroText
		LD	DE,AddendAsc
CmpAdd2:	LD	A,(DE)
		LD	(HL),A
		INC	HL
		CP	0
		JR	Z,CompAugend
		INC	DE
		JR	CmpAdd2
CompAugend:
		LD	DE,AugendAsc
CmpAug2:	LD	A,(DE)
		LD	(HL),A
		INC	HL
		CP	0
		JR	Z,CompSum
		INC	DE
		JR	CmpAug2
CompSum:
		LD	DE,SumAsc
CmpSum2:	LD	A,(DE)
		LD	(HL),A
		INC	HL
		CP	0
		JR	Z,PrintSum
		INC	DE
		JR	CmpSum2
PrintSum:
		LD	HL,AddMssg
		PUSH	HL
		LD	HL,MacroStart
		PUSH	HL
		LD	HL,AddScrn
		PUSH	HL
		CALL	ExpandMacros

		LD	HL,AddScrn
		JR	DoPrint
Error:		LD	HL,ErrorMssg
DoPrint:	LD	C,PCHARS
		RST	10h
		LD	C,EXIT
		RST	10h


	.DEPHASE
END